/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import it.jakegblp.lusk.utils.EntityUtils;
import java.util.Objects;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - Item from Equipment Slot")
@Description(value={"Gets the item in one or more equipment slots of one or more entities, if the entity cannot use a provided slot it will fail silently.\nThis might not work when trying to get a slot on an entity that doesnt have that slot AND if you're not running at least Paper 1.21\n\nCan be set."})
@Examples(value={"broadcast equipment slot chest slot"})
@Since(value={"1.3"})
public class ExprEntityEquipmentSlot
extends PropertyExpression<LivingEntity, ItemType> {
    Expression<EquipmentSlot> equipmentSlotExpression;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.equipmentSlotExpression = expressions[0];
            this.setExpr(expressions[1]);
        } else {
            this.equipmentSlotExpression = expressions[1];
            this.setExpr(expressions[0]);
        }
        return true;
    }

    @Override
    public boolean isSingle() {
        return super.isSingle() && this.equipmentSlotExpression.isSingle();
    }

    protected ItemType @NotNull [] get(@NotNull Event event, LivingEntity @NotNull [] source) {
        return (ItemType[])this.getExpr().stream(event).flatMap(entity -> this.equipmentSlotExpression.stream(event).map(equipmentSlot -> EntityUtils.getEntityEquipmentSlot(entity, equipmentSlot)).filter(Objects::nonNull).map(ItemType::new)).toArray(ItemType[]::new);
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray = new Class[1];
            object = classArray;
            classArray[0] = ItemType.class;
        } else {
            object = mode == Changer.ChangeMode.DELETE ? new Class[]{} : null;
        }
        return object;
    }

    public void change(@NotNull Event event, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        ItemStack itemStack;
        Object object;
        if (mode == Changer.ChangeMode.SET && delta.length > 0 && (object = delta[0]) instanceof ItemType) {
            ItemType itemType = (ItemType)object;
            itemStack = itemType.getRandom();
        } else {
            itemStack = null;
        }
        this.getExpr().stream(event).forEach(entity -> this.equipmentSlotExpression.stream(event).forEach(equipmentSlot -> EntityUtils.setEntityEquipmentSlot(entity, equipmentSlot, itemStack)));
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "equipment slots " + this.equipmentSlotExpression.toString(event, debug) + " of " + this.getExpr().toString(event, debug);
    }

    static {
        ExprEntityEquipmentSlot.register(ExprEntityEquipmentSlot.class, ItemType.class, "equipment[[ |-]slot][s] %equipmentslots%", "livingentities");
    }
}

