/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - is Interested (Property)")
@Description(value={"Returns whether or not the provided foxes or wolves are interested.\nPaper 1.18.2+ is required to use this with foxes."})
@Examples(value={"broadcast interested state of target"})
@Since(value={"1.0.2, 1.3 (Plural)"})
@DocumentationId(value="9056")
public class ExprEntityIsInterested
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Nullable
    public Boolean convert(LivingEntity from) {
        return EntityUtils.isInterested(from);
    }

    protected String getPropertyName() {
        return "is interested";
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public void set(LivingEntity from, Boolean bool) {
        EntityUtils.setIsInterested(from, bool);
    }

    @Override
    public void reset(LivingEntity from) {
        EntityUtils.setIsInterested(from, false);
    }

    static {
        ExprEntityIsInterested.register(ExprEntityIsInterested.class, Boolean.class, "[[living[ |-]]entity]", "[is] interested", "livingentities");
    }
}

