/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - is Sitting (Property)")
@Description(value={"Returns whether an entity is sat. Can be set.\nThis works for Cats, Wolves, Parrots, Pandas and Foxes.\nOn Paper 1.20.1+ it applies for some other entities which have a SITTING pose.\n"})
@Examples(value={"broadcast sitting state of target"})
@Since(value={"1.0.2"})
@DocumentationId(value="9057")
public class ExprEntityIsSitting
extends SimpleBooleanPropertyExpression<Entity> {
    @Nullable
    public Boolean convert(Entity from) {
        return EntityUtils.isSitting(from);
    }

    @Override
    public void set(Entity from, Boolean to) {
        EntityUtils.setIsSitting(from, to);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    protected String getPropertyName() {
        return "is sitting down";
    }

    static {
        ExprEntityIsSitting.register(ExprEntityIsSitting.class, Boolean.class, (String)"[is] s(at|it[ting]) [down]", (String)"entities");
    }
}

