/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Tameable;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - is Tamed (Property)")
@Description(value={"Returns whether the provided entities are tamed.\nCan be set.\n\nIf tamed, an entity cannot be tamed by a player through normal methods, even if it does not belong to anyone in particular.\n"})
@Examples(value={"broadcast is tamed state of target"})
@Since(value={"1.3.8"})
public class ExprEntityIsTamed
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Nullable
    public Boolean convert(LivingEntity from) {
        Tameable tameable;
        return from instanceof Tameable && (tameable = (Tameable)from).isTamed();
    }

    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof Tameable) {
            Tameable tameable = (Tameable)from;
            tameable.setTamed(to.booleanValue());
        }
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    protected String getPropertyName() {
        return "is tamed";
    }

    static {
        ExprEntityIsTamed.register(ExprEntityIsTamed.class, Boolean.class, "[tameable]", "[is] tamed", "livingentities");
    }
}

