/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - Love Duration")
@Description(value={"Returns the love duration of an animal.\n Can be set."})
@Examples(value={"on love:\n\tbroadcast the love duration", "broadcast love duration of target"})
@Since(value={"1.0.2, 1.0.3 (per Entity)"})
public class ExprEntityLoveDuration
extends SimpleExpression<Timespan> {
    boolean event;
    private Expression<Entity> entityExpression = null;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.event = this.getParser().isCurrentEvent(EntityEnterLoveModeEvent.class);
        if (!this.event && matchedPattern == 0 && exprs.length == 0) {
            Skript.error((String)"An entity must be specified outside of the Love event!");
            return false;
        }
        if (exprs.length == 1) {
            this.entityExpression = exprs[0];
        }
        return true;
    }

    protected Timespan @NotNull [] get(@NotNull Event e) {
        if (this.event && this.entityExpression == null) {
            return new Timespan[]{CompatibilityUtils.fromTicks(((EntityEnterLoveModeEvent)e).getTicksInLove())};
        }
        Entity entity = (Entity)this.entityExpression.getSingle(e);
        if (entity instanceof Animals) {
            Animals animal = (Animals)entity;
            return new Timespan[]{CompatibilityUtils.fromTicks(animal.getLoveModeTicks())};
        }
        return new Timespan[0];
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Timespan.class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object = delta[0];
        if (object instanceof Timespan) {
            Timespan timespan = (Timespan)object;
            if (this.entityExpression != null) {
                object = this.entityExpression.getSingle(e);
                if (object instanceof Animals) {
                    Animals animal = (Animals)object;
                    animal.setLoveModeTicks((int)CompatibilityUtils.getTicks(timespan));
                } else if (e instanceof EntityEnterLoveModeEvent) {
                    EntityEnterLoveModeEvent entityEnterLoveModeEvent = (EntityEnterLoveModeEvent)e;
                    entityEnterLoveModeEvent.setTicksInLove((int)CompatibilityUtils.getTicks(timespan));
                }
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the love duration" + (String)(this.entityExpression == null ? "" : " of " + (e == null ? "" : this.entityExpression.toString(e, debug)));
    }

    static {
        Skript.registerExpression(ExprEntityLoveDuration.class, Timespan.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] love duration [of %entity%]", "%entity%'[s] love duration"});
    }
}

