/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity/Snapshot - NBT String")
@Description(value={"Gets the provided entities or entity snapshots as their NBT string.\nDon't rely on this as the structure of the results can change across versions."})
@Examples(value={"set {_nbtString} to entity string nbt of {_entity}"})
@Since(value={"1.3"})
@RequiredPlugins(value={"1.20.5+"})
public class ExprEntityNBTString
extends SimplerPropertyExpression<Object, String> {
    @Nullable
    public String convert(Object from) {
        if (from instanceof Entity) {
            Entity entity = (Entity)from;
            return entity.getAsString();
        }
        if (from instanceof EntitySnapshot) {
            EntitySnapshot snapshot = (EntitySnapshot)from;
            return snapshot.getAsString();
        }
        return null;
    }

    protected String getPropertyName() {
        return "entity nbt string";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        if (Constants.MINECRAFT_1_20_5) {
            ExprEntityNBTString.register(ExprEntityNBTString.class, String.class, (String)"entity (nbt string|string nbt)", (String)"entities/entitysnapshots");
        }
    }
}

