/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Pose;
import org.jetbrains.annotations.NotNull;

@Name(value="Entity - Pose/Fixed Pose")
@Description(value={"Returns the provided entities' current pose.\nNote that the pose is only updated at the end of a tick, so it may be inconsistent.\n\nCan be set.\n\nSetting the \"Fixed\" pose will make it stay until manually changed, this requires Paper 1.20.1+\n"})
@Examples(value={"broadcast pose of target", "set fixed pose of target to dying pose"})
@Since(value={"1.0.2, 1.3 (Plural), 1.3.3 (Changeable and Fixed)"})
public class ExprEntityPose
extends SimplerPropertyExpression<Entity, Pose> {
    private boolean fixed;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.fixed = parseResult.hasTag("fixed");
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @NotNull
    public Class<? extends Pose> getReturnType() {
        return Pose.class;
    }

    @Override
    public boolean allowSet() {
        return Constants.PAPER_1_20_1;
    }

    @Override
    public void set(Entity from, Pose to) {
        from.setPose(to, this.fixed);
    }

    public Pose convert(Entity e) {
        return e.getPose();
    }

    @NotNull
    protected String getPropertyName() {
        return (this.fixed ? "fixed " : "") + "entity pose";
    }

    static {
        ExprEntityPose.register(ExprEntityPose.class, Pose.class, (String)((Constants.PAPER_1_20_1 ? "[:fixed] " : "") + "[entity] pose"), (String)"entities");
    }
}

