/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - Should Burn During The Day (Property)")
@Description(value={"Returns whether or not the provided entities should burn during the day.\nApplies to zombies, skeletons (all types), and phantoms\n\nIn 1.17.1 this doesn't work with skeleton variants, such as strays, but it does work with base skeletons.\n\nCan be set.\n"})
@Examples(value={"broadcast the should burn under sunlight property of target", "set the should burn during the day property of {_entity} to false"})
@Since(value={"1.0.3, 1.1.1 (Skeleton,Phantom), 1.3 (Safety), 1.3.3 (1.16.5 bug fixes)"})
@RequiredPlugins(value={"Paper"})
@DocumentationId(value="11901")
public class ExprEntityShouldBurnInDay
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Nullable
    public Boolean convert(LivingEntity from) {
        return EntityUtils.shouldBurnDuringTheDay(from);
    }

    @Override
    public void set(LivingEntity from, Boolean to) {
        EntityUtils.setShouldBurnDuringTheDay(from, to);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    protected String getPropertyName() {
        return "should burn under the sunlight";
    }

    static {
        ExprEntityShouldBurnInDay.register(ExprEntityShouldBurnInDay.class, Boolean.class, "[[living[ |-]]entity]", "(should|will) burn ((during|in) [the] day|(in|under) [the] (sun[light]|daylight))", "livingentities");
    }
}

