/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SpawnCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - Spawn Category")
@Description(value={"Returns the category of spawn to which this entity belongs."})
@Examples(value={"broadcast spawn category of target"})
@Since(value={"1.0.2, 1.3 (Plural)"})
public class ExprEntitySpawnCategory
extends SimplePropertyExpression<Entity, SpawnCategory> {
    @NotNull
    public Class<? extends SpawnCategory> getReturnType() {
        return SpawnCategory.class;
    }

    @Nullable
    public SpawnCategory convert(Entity e) {
        return e.getSpawnCategory();
    }

    @NotNull
    protected String getPropertyName() {
        return "spawn category";
    }

    static {
        if (Constants.HAS_SPAWN_CATEGORY) {
            ExprEntitySpawnCategory.register(ExprEntitySpawnCategory.class, SpawnCategory.class, (String)"spawn category", (String)"entities");
        }
    }
}

