/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.ClickEventTracker;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.Lusk;
import it.jakegblp.lusk.api.listeners.RightClickListener;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - on Right Click Section")
@Description(value={"Runs the code inside of it when the provided entity gets clicked.\n\nLocal Variables that are:\n- defined BEFORE this section CAN be used inside of it.\n- defined AFTER this section CANNOT be used inside of it.\n- defined INSIDE this section CANNOT be used outside of it.\n"})
@Examples(value={"command /a:\n  trigger:\n    spawn pig at player:\n      set display name of entity to \"&dPig\"\n      on click on entity:\n        broadcast \"%entity% has been clicked!\"\n"})
@Since(value={"1.1"})
public class SecEvtClick
extends Section {
    private static final ClickEventTracker entityInteractTracker = new ClickEventTracker((JavaPlugin)Lusk.getInstance());
    private Expression<Entity> entityExpression;
    @Nullable
    private Trigger trigger;

    public boolean init(Expression<?>[] expressions, int i, @NotNull Kleenean kleenean, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult, @NotNull SectionNode sectionNode, @NotNull List<TriggerItem> list) {
        this.entityExpression = expressions[0];
        this.trigger = this.loadCode(sectionNode, "click", new Class[]{PlayerInteractEntityEvent.class});
        return true;
    }

    @Nullable
    protected TriggerItem walk(@NotNull Event event) {
        if (event instanceof PlayerInteractEntityEvent) {
            PlayerInteractEntityEvent clickEvent2 = (PlayerInteractEntityEvent)event;
            if (clickEvent2 instanceof PlayerInteractAtEntityEvent && !(clickEvent2.getRightClicked() instanceof ArmorStand)) {
                return super.walk(event, false);
            }
            if (!(clickEvent2 instanceof PlayerInteractAtEntityEvent) && !entityInteractTracker.checkEvent(clickEvent2.getPlayer(), (Cancellable)clickEvent2, clickEvent2.getHand())) {
                return super.walk(event, false);
            }
        }
        Object vars = Variables.copyLocalVariables((Event)event);
        Consumer<PlayerInteractEntityEvent> consumer = this.trigger == null ? null : clickEvent -> {
            if (!entityInteractTracker.checkEvent(clickEvent.getPlayer(), (Cancellable)clickEvent, clickEvent.getHand())) {
                return;
            }
            Variables.setLocalVariables((Event)clickEvent, (Object)vars);
            TriggerItem.walk((TriggerItem)this.trigger, (Event)clickEvent);
            Variables.removeLocals((Event)clickEvent);
        };
        RightClickListener.log(consumer, (Entity)this.entityExpression.getSingle(event));
        return super.walk(event, false);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "when " + this.entityExpression.toString(event, b) + " gets clicked";
    }

    static {
        Skript.registerSection(SecEvtClick.class, (String[])new String[]{"[execute|run] on [right[ |-]]click (on|of) %~entity%", "[execute|run] when %~entity% get[s] [right[-| ]]clicked"});
    }
}

