/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.entity.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.events.GenericEntityJumpEvent;
import it.jakegblp.lusk.api.listeners.JumpListener;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity - on Jump Section")
@Description(value={"Runs the code inside of it when the provided entity jumps.\n\nOnly works for horses on Spigot, Paper is required for players and entities.\n\nLocal Variables that are:\n- defined BEFORE this section CAN be used inside of it.\n- defined AFTER this section CANNOT be used inside of it.\n- defined INSIDE this section CANNOT be used outside of it.\n"})
@Examples(value={"spawn villager at {_loc}:\n    on jump of entity:\n        broadcast \"%entity% has jumped!\"\n"})
@Since(value={"1.2"})
public class SecEvtJump
extends Section {
    private Expression<Entity> entity;
    @Nullable
    private Trigger trigger;

    public boolean init(Expression<?>[] expressions, int i, @NotNull Kleenean kleenean, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult, @NotNull SectionNode sectionNode, @NotNull List<TriggerItem> list) {
        this.entity = expressions[0];
        this.trigger = this.loadCode(sectionNode, "jump", new Class[]{GenericEntityJumpEvent.class});
        return true;
    }

    @Nullable
    protected TriggerItem walk(@NotNull Event event) {
        Object vars = Variables.copyLocalVariables((Event)event);
        Consumer<GenericEntityJumpEvent> consumer = this.trigger == null ? null : entityJumpEvent -> {
            Variables.setLocalVariables((Event)entityJumpEvent, (Object)vars);
            TriggerItem.walk((TriggerItem)this.trigger, (Event)entityJumpEvent);
            Variables.removeLocals((Event)entityJumpEvent);
        };
        JumpListener.log(consumer, (Entity)this.entity.getSingle(event));
        return super.walk(event, false);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "when " + this.entity.toString(event, b) + " jumps";
    }

    static {
        Skript.registerSection(SecEvtJump.class, (String[])new String[]{"[execute|run] on %~entity% jump[ing]", "[execute|run] when %~entity% jump[s]"});
    }
}

