/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.fireball.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SizedFireball;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="Fireball - Displayed Item")
@Description(value={"Gets the displayed item of the provided fireballs.\nCan be set."})
@Examples(value={"broadcast fireball item of target"})
@Since(value={"1.0.3, 1.3 (Plural)"})
public class ExprFireballItem
extends SimplerPropertyExpression<Projectile, ItemType> {
    @Nullable
    public ItemType convert(Projectile from) {
        ItemType itemType;
        if (from instanceof SizedFireball) {
            SizedFireball fireball = (SizedFireball)from;
            itemType = new ItemType(fireball.getDisplayItem());
        } else {
            itemType = null;
        }
        return itemType;
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public void set(Projectile from, ItemType to) {
        if (from instanceof SizedFireball) {
            SizedFireball fireball = (SizedFireball)from;
            ItemStack item = to.getRandom();
            if (item == null) {
                return;
            }
            fireball.setDisplayItem(item);
        }
    }

    protected String getPropertyName() {
        return "displayed fireball item";
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    static {
        ExprFireballItem.register(ExprFireballItem.class, ItemType.class, (String)"[displayed] fireball item", (String)"projectiles");
    }
}

