/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.fox.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.PrefixedPropertyCondition;
import org.bukkit.entity.Fox;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Fox - is Crouching")
@Description(value={"Checks if a fox is crouching."})
@Examples(value={"on damage of fox:\n\tif victim is crouching:\n\t\tcancel event"})
@Since(value={"1.0.0"})
public class CondFoxCrouching
extends PrefixedPropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        Fox fox;
        return entity instanceof Fox && (fox = (Fox)entity).isCrouching();
    }

    @NotNull
    protected String getPropertyName() {
        return "crouching";
    }

    @Override
    public String getPrefix() {
        return "foxes";
    }

    static {
        CondFoxCrouching.register(CondFoxCrouching.class, "[fox[es]]", "crouching", "livingentities");
    }
}

