/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.fox.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.PrefixedPropertyCondition;
import org.bukkit.entity.Fox;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Name(value="Fox - is Faceplanted")
@Description(value={"Checks if the fox is faceplanted."})
@Examples(value={"on damage of fox:\n\tif victim is faceplanted:\n\t\tcancel event"})
@Since(value={"1.0.0"})
public class CondFoxFaceplanted
extends PrefixedPropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        Fox fox;
        return entity instanceof Fox && (fox = (Fox)entity).isFaceplanted();
    }

    @NotNull
    protected String getPropertyName() {
        return "faceplanted";
    }

    @Override
    public String getPrefix() {
        return "foxes";
    }

    static {
        CondFoxFaceplanted.register(CondFoxFaceplanted.class, "[fox[es]]", "face[ |-]planted", "livingentities");
    }
}

