/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.fox.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.bukkit.entity.Fox;
import org.bukkit.entity.LivingEntity;

@Name(value="Fox - is Crouching (Property)")
@Description(value={"Gets whether the provided foxes are crouching, can be set and reset."})
@Examples(value={"broadcast the fox is crouching property of target"})
@Since(value={"1.3"})
public class ExprFoxCrouching
extends SimpleBooleanPropertyExpression<LivingEntity> {
    public Boolean convert(LivingEntity from) {
        Fox fox;
        return from instanceof Fox && (fox = (Fox)from).isCrouching();
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Override
    public void set(LivingEntity from, Boolean bool) {
        if (from instanceof Fox) {
            Fox fox = (Fox)from;
            fox.setCrouching(bool.booleanValue());
        }
    }

    @Override
    public void reset(LivingEntity from) {
        this.set(from, (Boolean)false);
    }

    protected String getPropertyName() {
        return "fox is crouching";
    }

    static {
        ExprFoxCrouching.register(ExprFoxCrouching.class, Boolean.class, "fox", "[is] crouching", "livingentities");
    }
}

