/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.fox.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Fox;
import org.bukkit.entity.LivingEntity;

@Name(value="Fox - is Defending (Property)")
@Description(value={"Gets whether the provided foxed are defending, can be set and reset."})
@Examples(value={"broadcast the fox is defending property of target"})
@Since(value={"1.3"})
@RequiredPlugins(value={"Paper 1.18.2+"})
public class ExprFoxDefending
extends SimpleBooleanPropertyExpression<LivingEntity> {
    public Boolean convert(LivingEntity from) {
        Fox fox;
        return from instanceof Fox && (fox = (Fox)from).isDefending();
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Override
    public void set(LivingEntity from, Boolean bool) {
        if (from instanceof Fox) {
            Fox fox = (Fox)from;
            fox.setDefending(bool.booleanValue());
        }
    }

    @Override
    public void reset(LivingEntity from) {
        this.set(from, (Boolean)false);
    }

    protected String getPropertyName() {
        return "fox is defending";
    }

    static {
        if (Constants.PAPER_1_18_2) {
            ExprFoxDefending.register(ExprFoxDefending.class, Boolean.class, "fox", "[is] defending", "livingentities");
        }
    }
}

