/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.fox.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Fox;
import org.bukkit.entity.LivingEntity;

@Name(value="Fox - is Faceplanted (Property)")
@Description(value={"Gets whether the provided foxes are faceplanted, if running Paper this can be set and reset."})
@Examples(value={"broadcast the fox is faceplanted property of target"})
@Since(value={"1.3"})
public class ExprFoxFaceplanted
extends SimpleBooleanPropertyExpression<LivingEntity> {
    protected String getPropertyName() {
        return "fox is faceplanted";
    }

    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof Fox) {
            Fox fox = (Fox)from;
            fox.setFaceplanted(to.booleanValue());
        }
    }

    @Override
    public void reset(LivingEntity from) {
        this.set(from, (Boolean)false);
    }

    public Boolean convert(LivingEntity from) {
        Fox fox;
        return from instanceof Fox && (fox = (Fox)from).isFaceplanted();
    }

    @Override
    public boolean allowSet() {
        return Constants.PAPER_1_18_2;
    }

    @Override
    public boolean allowReset() {
        return Constants.PAPER_1_18_2;
    }

    static {
        ExprFoxFaceplanted.register(ExprFoxFaceplanted.class, Boolean.class, "fox", "[is] face[ |-]planted", "livingentities");
    }
}

