/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.fox.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import org.bukkit.entity.Fox;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Fox - Variant")
@Description(value={"Gets the current type of this fox.\nCan bet set."})
@Examples(value={"set fox type of {_fox} to red_fox_type"})
@Since(value={"1.3"})
public class ExprFoxVariant
extends SimplerPropertyExpression<LivingEntity, Fox.Type> {
    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public void set(LivingEntity from, Fox.Type to) {
        if (from instanceof Fox) {
            Fox fox = (Fox)from;
            fox.setFoxType(to);
        }
    }

    @Nullable
    public Fox.Type convert(LivingEntity from) {
        if (from instanceof Fox) {
            Fox fox = (Fox)from;
            return fox.getFoxType();
        }
        return null;
    }

    protected String getPropertyName() {
        return "fox variant";
    }

    public Class<? extends Fox.Type> getReturnType() {
        return Fox.Type.class;
    }

    static {
        ExprFoxVariant.register(ExprFoxVariant.class, Fox.Type.class, (String)"fox (variant|type)", (String)"livingentities");
    }
}

