/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.goat.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import it.jakegblp.lusk.utils.LuskUtils;
import org.bukkit.entity.Goat;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Goat - Has Left/Right/Both/Either Horn")
@Description(value={"Checks if goat has the left, right, both or either horn."})
@Examples(value={"if target has its left horn:"})
@Since(value={"1.0.3, 1.3 (Plural, Both/Either)"})
public class CondGoatHasHorns
extends Condition {
    private Expression<LivingEntity> entityExpression;
    private Kleenean left = null;
    private boolean both = false;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        this.entityExpression = expressions[0];
        if (matchedPattern > 1) {
            this.both = true;
        } else {
            this.left = LuskUtils.getKleenean(parser.hasTag("left"), parser.hasTag("right"));
        }
        this.setNegated(matchedPattern % 2 != 0);
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        String string;
        String string2 = this.entityExpression.toString(event, debug);
        String string3 = this.isNegated() ? " does not have " : " has ";
        if (this.both) {
            string = "both horns";
        } else {
            switch (this.left) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case TRUE: {
                    string = "its left horn";
                    break;
                }
                case FALSE: {
                    string = "its right horn";
                    break;
                }
                case UNKNOWN: {
                    string = "either horn";
                }
            }
        }
        return string2 + string3 + string;
    }

    public boolean check(@NotNull Event event) {
        return CompatibilityUtils.test(this.entityExpression, event, entity -> {
            boolean bl;
            block10: {
                block7: {
                    block9: {
                        Goat goat;
                        block8: {
                            if (!(entity instanceof Goat)) break block7;
                            goat = (Goat)entity;
                            if (!this.both) break block8;
                            if (!goat.hasLeftHorn() || !goat.hasRightHorn()) break block7;
                            break block9;
                        }
                        switch (this.left) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case TRUE: {
                                if (goat.hasLeftHorn()) {
                                    break;
                                }
                                break block7;
                            }
                            case FALSE: {
                                if (goat.hasRightHorn()) {
                                    break;
                                }
                                break block7;
                            }
                            case UNKNOWN: {
                                if (!goat.hasLeftHorn() && !goat.hasRightHorn()) break block7;
                            }
                        }
                    }
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            return bl;
        });
    }

    static {
        Skript.registerCondition(CondGoatHasHorns.class, (String[])new String[]{"%livingentities% (has|have) [its|the[ir]] (:left|:right|either|any) [goat] horn", "%livingentities% (doesn't|does not|do not|don't) have [its|the[ir]] (:left|:right|either|any) [goat] horn", "%livingentities% (has|have) [its|the[ir]|both] [goat] horns", "%livingentities% (doesn't|does not|do not|don't) have [its|the[ir]|both] [goat] horns"});
    }
}

