/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.horse.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Horse - is Eating Grass (Property)")
@Description(value={"Returns whether or not an horse is eating grass.\nCan be set and reset."})
@Examples(value={"broadcast horse eating grass state of target"})
@Since(value={"1.0.3"})
public class ExprHorseEatingGrassState
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)from;
            horse.setEatingGrass(to.booleanValue());
        }
    }

    @Override
    public void reset(LivingEntity from) {
        this.set(from, (Boolean)false);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Nullable
    public Boolean convert(LivingEntity from) {
        AbstractHorse horse;
        return from instanceof AbstractHorse && (horse = (AbstractHorse)from).isEatingGrass();
    }

    protected String getPropertyName() {
        return "horse is eating grass state";
    }

    static {
        ExprHorseEatingGrassState.register(ExprHorseEatingGrassState.class, Boolean.class, "horse", "[is] eating grass", "livingentities");
    }
}

