/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.horse.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Horse - is Eating (Property)")
@Description(value={"Returns whether or not an horse is eating.\nCan be set and reset."})
@Examples(value={"broadcast horse eating state of target"})
@Since(value={"1.0.3"})
public class ExprHorseEatingState
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)from;
            horse.setEating(to.booleanValue());
        }
    }

    @Override
    public void reset(LivingEntity from) {
        this.set(from, (Boolean)false);
    }

    @Nullable
    public Boolean convert(LivingEntity from) {
        AbstractHorse horse;
        return from instanceof AbstractHorse && (horse = (AbstractHorse)from).isEating();
    }

    protected String getPropertyName() {
        return "horse is eating state";
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    static {
        ExprHorseEatingState.register(ExprHorseEatingState.class, Boolean.class, "horse", "[is] eating", "livingentities");
    }
}

