/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.horse.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@Name(value="Horse - is Rearing (Property)")
@Description(value={"Returns whether or not an horse is rearing.\nCan be set and reset."})
@Examples(value={"broadcast horse rearing state of target"})
@Since(value={"1.0.3"})
public class ExprHorseRearingState
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)from;
            horse.setRearing(to.booleanValue());
        }
    }

    @Override
    public void reset(LivingEntity from) {
        this.set(from, (Boolean)false);
    }

    @Nullable
    public Boolean convert(LivingEntity from) {
        AbstractHorse horse;
        return from instanceof AbstractHorse && (horse = (AbstractHorse)from).isRearing();
    }

    protected String getPropertyName() {
        return "horse is rearing state";
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    static {
        ExprHorseRearingState.register(ExprHorseRearingState.class, Boolean.class, "horse", "[is] rearing", "livingentities");
    }
}

