/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.itemframe.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.skript.PrefixedPropertyCondition;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;

@Name(value="Item Frame - is Visible / is Invisible")
@Description(value={"Returns whether the item frame is visible or not."})
@Examples(value={"if item frame {_itemFrame} is visible:"})
@Since(value={"1.3"})
public class CondItemFrameVisible
extends PrefixedPropertyCondition<Entity> {
    private boolean invisible;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.invisible = parseResult.hasTag("in");
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    public boolean check(Entity value) {
        ItemFrame itemFrame;
        return value instanceof ItemFrame && (itemFrame = (ItemFrame)value).isVisible() ^ this.invisible;
    }

    protected String getPropertyName() {
        return (this.invisible ? "in" : "") + "visible";
    }

    @Override
    public String getPrefix() {
        return "item frame";
    }

    static {
        CondItemFrameVisible.register(CondItemFrameVisible.class, "item[ |-]frame", "[:in]visible", "entities");
    }
}

