/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.itemframe.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.ItemFrameUtils;
import java.util.List;
import org.bukkit.Rotation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Item Frame - Rotate")
@Description(value={"Rotates item frames counter clockwise and clockwise or by specific rotations and a set amount of times."})
@Examples(value={"rotate {_itemFrame} by 45 degrees twice"})
@Since(value={"1.3"})
public class EffItemFrameRotate
extends Effect {
    private Expression<Entity> entityExpression;
    private Expression<Rotation> rotationExpression;
    private Expression<Number> numberExpression;
    private boolean clockwise = false;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityExpression = expressions[0];
        if (matchedPattern == 0) {
            this.clockwise = !parseResult.hasTag("counter");
            this.rotationExpression = null;
            this.numberExpression = expressions[1];
        } else {
            this.rotationExpression = expressions[1];
            this.numberExpression = expressions[2];
        }
        return true;
    }

    protected void execute(Event event) {
        List<ItemFrame> itemFrameList = this.entityExpression.stream(event).filter(entity -> entity instanceof ItemFrame).map(entity -> (ItemFrame)entity).toList();
        if (itemFrameList.isEmpty()) {
            return;
        }
        int times = Math.max(1, this.numberExpression.stream(event).mapToInt(Number::intValue).max().orElse(1));
        if (this.rotationExpression == null) {
            itemFrameList.forEach(itemFrame -> ItemFrameUtils.rotateItemFrame((Entity)itemFrame, this.clockwise, times));
        } else {
            itemFrameList.forEach(itemFrame -> itemFrame.setRotation(ItemFrameUtils.sumRotations(this.rotationExpression.stream(event), itemFrame.getRotation(), times)));
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "rotate item frames " + this.entityExpression.toString(event, debug) + (this.rotationExpression == null ? (this.clockwise ? " " : " counter ") + "clockwise" : " by " + this.rotationExpression.toString(event, debug)) + " " + this.numberExpression.toString(event, debug) + " times";
    }

    static {
        Skript.registerEffect(EffItemFrameRotate.class, (String[])new String[]{"rotate [item[ |-]frame[s]] %entities% [:counter] clockwise [%numbers%]", "rotate [item[ |-]frame[s]] %entities% by %rotations% [%numbers%]"});
    }
}

