/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.itemframe.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import io.papermc.paper.event.player.PlayerItemFrameChangeEvent;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvtItemFrameChange
extends SkriptEvent {
    private String action;

    public boolean init(Literal<?> @NotNull [] args, int matchedPattern, @NotNull SkriptParser.ParseResult parseResult) {
        if (parseResult.hasTag("place")) {
            this.action = "PLACE";
        } else if (parseResult.hasTag("remove")) {
            this.action = "REMOVE";
        } else if (parseResult.hasTag("rotate")) {
            this.action = "ROTATE";
        }
        return true;
    }

    public boolean check(@NotNull Event e) {
        if (this.action == null) {
            return true;
        }
        return this.action.equals(((PlayerItemFrameChangeEvent)e).getAction().toString());
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return switch (this.action) {
            case "PLACE" -> "item frame place";
            case "REMOVE" -> "item frame remove";
            case "ROTATE" -> "item frame rotate";
            default -> "item frame interact";
        };
    }

    static {
        if (Skript.classExists((String)"io.papermc.paper.event.player.PlayerItemFrameChangeEvent")) {
            Skript.registerEvent((String)"Item Frame - on Change", EvtItemFrameChange.class, PlayerItemFrameChangeEvent.class, (String[])new String[]{"item[ |-]frame [item] [place:(insert|place)|:remove|:rotate|interact|change]"}).description(new String[]{"Called when an ItemFrame is having an item rotated, added, or removed from it."}).examples(new String[]{"on itemframe rotate:\n  broadcast \"rotated\"\n\non itemframe remove:\n  broadcast \"remove\"\n\non itemframe place:\n  broadcast \"place\"\n"}).since("1.0.0").requiredPlugins(new String[]{"Paper"});
            CompatibilityUtils.registerEventValue(PlayerItemFrameChangeEvent.class, Entity.class, PlayerItemFrameChangeEvent::getItemFrame, 0);
            CompatibilityUtils.registerEventValue(PlayerItemFrameChangeEvent.class, ItemStack.class, PlayerItemFrameChangeEvent::getItemStack, 0);
        }
    }
}

