/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.itemframe.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.jetbrains.annotations.Nullable;

@Name(value="Item Frame - is Fixed (Property)")
@Description(value={"Gets whether the item frame is \"fixed\" or not.\nCan be set and reset.\nWhen true it's not possible to destroy/move the frame (e. g. by damage, interaction, pistons, or missing supporting blocks), rotate the item or place/remove items."})
@Examples(value={"set whether item frame {_itemFrame} is fixed to true", "broadcast whether item frame target is fixed"})
@Since(value={"1.3"})
public class ExprItemFrameIsFixed
extends SimpleBooleanPropertyExpression<Entity> {
    @Override
    public void set(Entity from, Boolean to) {
        if (from instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)from;
            itemFrame.setFixed(to.booleanValue());
        }
    }

    @Override
    public void reset(Entity from) {
        this.set(from, (Boolean)false);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Nullable
    public Boolean convert(Entity from) {
        ItemFrame itemFrame;
        return from instanceof ItemFrame && (itemFrame = (ItemFrame)from).isFixed();
    }

    protected String getPropertyName() {
        return "item frame is fixed property";
    }

    static {
        ExprItemFrameIsFixed.register(ExprItemFrameIsFixed.class, Boolean.class, "item[ |-]frame", "[is] fixed", "entities");
    }
}

