/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.itemframe.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import it.jakegblp.lusk.elements.other.sections.SecSilent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.jetbrains.annotations.Nullable;

@Name(value="Item Frame - Item (Silently Set)")
@Description(value={"Gets a copy of the item in the provided item frames.\nCan be set and deleted, this expression supports the Silent Section, see examples."})
@Examples(value={"send item frame item of {_frame}", "silently:\n  set item frame item of {_frame} to stone\n"})
public class ExprItemFrameItem
extends SimplerPropertyExpression<Entity, ItemType> {
    private boolean silently;

    @Nullable
    public ItemType convert(Entity from) {
        if (from instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)from;
            return new ItemType(itemFrame.getItem());
        }
        return null;
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowDelete() {
        return true;
    }

    @Override
    public void set(Entity from, ItemType to) {
        if (from instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)from;
            itemFrame.setItem(to == null ? null : to.getRandom(), !this.silently);
        }
    }

    @Override
    public void delete(Entity from) {
        this.set(from, null);
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.silently = this.getParser().isCurrentSection(SecSilent.class);
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    protected String getPropertyName() {
        return "item frame item";
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    static {
        ExprItemFrameItem.register(ExprItemFrameItem.class, ItemType.class, (String)"item[ |-]frame item", (String)"entities");
    }
}

