/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.itemframe.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import org.bukkit.Rotation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.jetbrains.annotations.Nullable;

@Name(value="Item Frame - Rotation")
@Description(value={"Returns the rotation of an Item Frame."})
@Examples(value={"broadcast item frame rotation of target"})
@Since(value={"1.0.2, 1.3 (Reworked)"})
public class ExprItemFrameRotation
extends SimplerPropertyExpression<Entity, Rotation> {
    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Override
    public boolean allowDelete() {
        return true;
    }

    @Override
    public void set(Entity from, Rotation to) {
        if (from instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)from;
            itemFrame.setRotation(to);
        }
    }

    @Override
    public void delete(Entity from) {
        this.reset(from);
    }

    @Override
    public void reset(Entity from) {
        this.set(from, Rotation.NONE);
    }

    @Nullable
    public Rotation convert(Entity from) {
        if (from instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)from;
            return itemFrame.getRotation();
        }
        return null;
    }

    protected String getPropertyName() {
        return "itemframe rotation";
    }

    public Class<? extends Rotation> getReturnType() {
        return Rotation.class;
    }

    static {
        ExprItemFrameRotation.register(ExprItemFrameRotation.class, Rotation.class, (String)"item[ |-]frame rotation", (String)"entities");
    }
}

