/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.llama.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.jetbrains.annotations.NotNull;

@Name(value="Llama - is In Caravan")
@Description(value={"Checks if a llama is in a caravan."})
@Examples(value={"if target is in a caravan:"})
@Since(value={"1.0.3, 1.3 (Plural)"})
@RequiredPlugins(value={"Paper 1.19.2+"})
public class CondLlamaInCaravan
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        Llama llama;
        return entity instanceof Llama && (llama = (Llama)entity).inCaravan();
    }

    @NotNull
    protected String getPropertyName() {
        return "in a caravan";
    }

    static {
        if (Constants.PAPER_1_19_2) {
            CondLlamaInCaravan.register(CondLlamaInCaravan.class, (String)"in [a] caravan", (String)"livingentities");
        }
    }
}

