/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.ocelot.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.jetbrains.annotations.Nullable;

@Name(value="Ocelot - is Trusting (Property)")
@Description(value={"Returns whether or not an ocelot trusts players.\nCan be set."})
@Examples(value={"broadcast ocelot trusting state of target"})
@Since(value={"1.0.2"})
public class ExprOcelotTrustingState
extends SimpleBooleanPropertyExpression<LivingEntity> {
    @Override
    public void set(LivingEntity from, Boolean to) {
        if (from instanceof Ocelot) {
            Ocelot ocelot = (Ocelot)from;
            ocelot.setTrusting(to.booleanValue());
        }
    }

    @Override
    public void reset(LivingEntity from) {
        this.set(from, (Boolean)false);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Nullable
    public Boolean convert(LivingEntity from) {
        Ocelot ocelot;
        return from instanceof Ocelot && (ocelot = (Ocelot)from).isTrusting();
    }

    protected String getPropertyName() {
        return "ocelot is trusting state";
    }

    static {
        ExprOcelotTrustingState.register(ExprOcelotTrustingState.class, Boolean.class, "ocelot", "([is] trusting|trust[s])", "livingentities");
    }
}

