/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import io.papermc.paper.event.player.PlayerFlowerPotManipulateEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="is Placing in Pot")
@Description(value={"This Condition requires Paper.\n\nChecks whether or not the item is being placed inside the flower pot in a Flower Pot Manipulate Event."})
@Examples(value={"on potting of cornflower:\n  if the plant is being placed:\n    broadcast \"placed\"\n  else if the plant is being picked up:\n    broadcast \"picked up\"\n"})
@Since(value={"1.0.0"})
@RequiredPlugins(value={"Paper"})
public class CondPlacingFlower
extends Condition {
    private boolean placed;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        if (!this.getParser().isCurrentEvent(PlayerFlowerPotManipulateEvent.class)) {
            Skript.error((String)"This condition can only be used in the Flower Pot Manipulate event!");
            return false;
        }
        this.placed = parser.hasTag("placed");
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "the item is" + (this.isNegated() ? " not" : "") + " being " + (this.placed ? "placed" : "picked up");
    }

    public boolean check(@NotNull Event event) {
        return !this.placed ^ this.isNegated() ^ ((PlayerFlowerPotManipulateEvent)event).isPlacing();
    }

    static {
        if (Skript.classExists((String)"io.papermc.paper.event.player.PlayerFlowerPotManipulateEvent")) {
            Skript.registerCondition(CondPlacingFlower.class, (String[])new String[]{"[the] (flower|plant|item) is being (:placed|picked up)", "[the] (flower|plant|item) is(n't| not) being (:placed|picked up)"});
        }
    }
}

