/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.EntityUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Name(value="Player - Can Critical Damage")
@Description(value={"Checks if a player is in position to inflict a critical hit.\n\nRead https://minecraft.fandom.com/wiki/Damage#Critical_hit for more info."})
@Examples(value={"if player can critical damage:"})
@Since(value={"1.0.2"})
public class CondPlayerCanCriticalDamage
extends PropertyCondition<Player> {
    public boolean check(Player player) {
        return EntityUtils.canCriticalDamage((Entity)player);
    }

    @NotNull
    protected String getPropertyName() {
        return "critical damage";
    }

    static {
        CondPlayerCanCriticalDamage.register(CondPlayerCanCriticalDamage.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.CAN, (String)"crit[ical[ly] (damage|hit|attack)]", (String)"players");
    }
}

