/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.events.PlayerInventorySlotDropEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="on Inventory Slot Drop - Drop Info")
@Description(value={"Checks if the item is being dropped from the cursor or the inventory, if the whole stack is being dropped or both.\n"})
@Examples(value={"if the item is not getting dropped from the cursor:", "if the whole stack is being dropped:"})
@Since(value={"1.3"})
public class CondSlotDropInfo
extends Condition {
    private boolean choice = true;
    private boolean cursor;
    private boolean fullStack;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        if (!this.getParser().isCurrentEvent(PlayerInventorySlotDropEvent.class)) {
            Skript.error((String)"This condition can only be used in the Inventory Slot Drop event!");
            return false;
        }
        boolean bl = this.fullStack = matchedPattern == 1;
        if (parser.hasTag("cursor")) {
            this.cursor = true;
        } else if (parser.hasTag("inventory")) {
            this.cursor = false;
        } else {
            this.choice = false;
        }
        this.setNegated(parser.hasTag("not"));
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        StringBuilder builder = new StringBuilder();
        builder.append("the ").append(this.fullStack ? "full stack" : "item").append(" is ").append(this.isNegated() ? "not " : "").append(" being dropped");
        if (this.choice) {
            builder.append(" from ").append(this.cursor ? "cursor" : "inventory");
        }
        return builder.toString();
    }

    public boolean check(@NotNull Event event) {
        boolean value;
        PlayerInventorySlotDropEvent e = (PlayerInventorySlotDropEvent)event;
        if (this.fullStack) {
            value = e.isDropsAll();
            if (this.choice) {
                value = value && this.cursor == e.isDropsFromCursor();
            }
        } else {
            value = this.choice ? this.cursor == e.isDropsFromCursor() : !e.isDropsFromCursor();
        }
        return this.isNegated() ^ value;
    }

    static {
        Skript.registerCondition(CondSlotDropInfo.class, (String[])new String[]{"[the] item is[not:( not|n't)] [being|getting] dropped from the (:cursor|:inventory)", "[the] (whole|full) stack is[not:( not|n't)] [being|getting] dropped [from the (:cursor|:inventory)]"});
    }
}

