/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import io.papermc.paper.event.player.PlayerFlowerPotManipulateEvent;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvtFlowerPotManipulate
extends SkriptEvent {
    private ItemType flower;

    public boolean init(Literal<?> @NotNull [] args, int matchedPattern, @NotNull SkriptParser.ParseResult parseResult) {
        if (args.length > 0) {
            this.flower = args[0] == null ? null : (ItemType)args[0].getSingle();
        }
        return true;
    }

    public boolean check(@NotNull Event e) {
        if (this.flower == null) {
            return true;
        }
        @NotNull Material item = ((PlayerFlowerPotManipulateEvent)e).getItem().getType();
        return this.flower.getMaterial() == item;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "flower pot" + (String)(this.flower == null ? "" : " of " + String.valueOf(this.flower));
    }

    static {
        if (Skript.classExists((String)"io.papermc.paper.event.player.PlayerFlowerPotManipulateEvent")) {
            Skript.registerEvent((String)"Flower Pot - on Manipulate", EvtFlowerPotManipulate.class, PlayerFlowerPotManipulateEvent.class, (String[])new String[]{"[flower] pot[ting)| manipulat(e|ing)] [of %itemtype%]"}).description(new String[]{"Called when a player places an item in or takes an item out of a flowerpot."}).examples(new String[]{"on potting of cornflower:\n  if the plant is being placed:\n    broadcast \"placed\"\n  else if the plant is being picked up:\n    broadcast \"picked up\"\n"}).requiredPlugins(new String[]{"Paper"}).since("1.0.0");
            CompatibilityUtils.registerEventValue(PlayerFlowerPotManipulateEvent.class, ItemStack.class, PlayerFlowerPotManipulateEvent::getItem, 0);
            CompatibilityUtils.registerEventValue(PlayerFlowerPotManipulateEvent.class, Block.class, PlayerFlowerPotManipulateEvent::getFlowerpot, 0);
        }
    }
}

