/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.paperlib.PaperLib;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import it.jakegblp.lusk.utils.LuskUtils;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class EvtPlayerInteract
extends SkriptEvent {
    private Kleenean isEntityInteraction;
    private Kleenean isMainHandInteraction;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.isEntityInteraction = LuskUtils.getKleenean(parseResult.hasTag("entity"), parseResult.hasTag("block"));
        this.isMainHandInteraction = LuskUtils.getKleenean(parseResult.hasTag("main"), parseResult.hasTag("off"));
        return true;
    }

    public boolean check(Event e) {
        boolean result = false;
        EquipmentSlot hand = null;
        if (!this.isEntityInteraction.isFalse() && e instanceof PlayerInteractAtEntityEvent) {
            PlayerInteractAtEntityEvent event = (PlayerInteractAtEntityEvent)e;
            result = true;
            hand = event.getHand();
        } else if (!this.isEntityInteraction.isTrue() && e instanceof PlayerInteractEvent) {
            PlayerInteractEvent event = (PlayerInteractEvent)e;
            result = true;
            hand = event.getHand();
        }
        if (!result || hand == null) {
            return result;
        }
        return switch (this.isMainHandInteraction) {
            default -> throw new IncompatibleClassChangeError();
            case Kleenean.TRUE -> hand.equals((Object)EquipmentSlot.HAND);
            case Kleenean.FALSE -> hand.equals((Object)EquipmentSlot.OFF_HAND);
            case Kleenean.UNKNOWN -> true;
        };
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "player " + (switch (this.isMainHandInteraction) {
            default -> throw new IncompatibleClassChangeError();
            case Kleenean.TRUE -> "main hand ";
            case Kleenean.FALSE -> "off hand ";
            case Kleenean.UNKNOWN -> "";
        }) + "interaction" + (switch (this.isEntityInteraction) {
            default -> throw new IncompatibleClassChangeError();
            case Kleenean.TRUE -> " with an entity";
            case Kleenean.FALSE -> " with a block";
            case Kleenean.UNKNOWN -> "";
        });
    }

    static {
        Skript.registerEvent((String)"Player - on Interact", EvtPlayerInteract.class, (Class[])((Class[])CollectionUtils.array((Object[])new Class[]{PlayerInteractEvent.class, PlayerInteractAtEntityEvent.class})), (String[])new String[]{"player [[:main|:off][ |-]hand [slot]] interact[ing|ion] [entity:(on|with|at) [an] entity|block:(with|on) [a] block]"}).description(new String[]{"Called when a player interacts with a block or entity by clicking.\n\nThis event is always called unlike Skript's click event, meaning that it can be called for both hands.\n\nYou can use `main hand` and `off hand` to make it per hand.\n\n`event-equipmentslot` = the slot of the used hand\n`event-blockaction` = the action of this event\n`event-vector` = the vector from the player to the interaction point\n`event-location` = the location of the interaction point\n"}).examples(new String[]{"on player main hand interaction:", "on player interacting with an entity:\n\tif event-equipmentslot = hand slot:"}).since("1.3");
        CompatibilityUtils.registerEventValue(PlayerInteractEvent.class, EquipmentSlot.class, PlayerInteractEvent::getHand, 0);
        CompatibilityUtils.registerEventValue(PlayerInteractEvent.class, Action.class, PlayerInteractEvent::getAction, 0);
        CompatibilityUtils.registerEventValue(PlayerInteractEvent.class, Vector.class, e -> {
            if (!PaperLib.isPaper()) {
                return e.getClickedPosition();
            }
            Location interactionPoint = e.getInteractionPoint();
            if (interactionPoint == null) {
                return null;
            }
            return interactionPoint.getDirection().subtract(e.getPlayer().getLocation().getDirection());
        }, 0);
        CompatibilityUtils.registerEventValue(PlayerInteractEvent.class, Location.class, e -> {
            if (PaperLib.isPaper()) {
                return e.getInteractionPoint();
            }
            Vector offset = e.getClickedPosition();
            if (offset == null) {
                return null;
            }
            return e.getPlayer().getLocation().add(offset);
        }, 0);
        CompatibilityUtils.registerEventValue(PlayerInteractEntityEvent.class, EquipmentSlot.class, PlayerInteractEntityEvent::getHand, 0);
        CompatibilityUtils.registerEventValue(PlayerInteractAtEntityEvent.class, Location.class, e -> e.getRightClicked().getLocation().add(e.getClickedPosition()), 0);
        CompatibilityUtils.registerEventValue(PlayerInteractAtEntityEvent.class, Vector.class, PlayerInteractAtEntityEvent::getClickedPosition, 0);
    }
}

