/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

@Name(value="on Velocity Change - New Velocity Vector")
@Description(value={"The velocity vector in the Player Velocity Change Event, can be set, deleted and reset."})
@Examples(value={"set the new player velocity to vector(4,6,3)"})
@Since(value={"1.3"})
public class ExprNewVelocity
extends SimpleExpression<Vector> {
    @Nullable
    protected Vector[] get(Event event) {
        PlayerVelocityEvent playerVelocityEvent = (PlayerVelocityEvent)event;
        return new Vector[]{playerVelocityEvent.getVelocity()};
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Vector v;
        Object object;
        Vector vector = delta == null ? new Vector() : (delta.length > 0 ? ((object = delta[0]) instanceof Vector ? (v = (Vector)object) : new Vector()) : new Vector());
        Vector vector2 = vector;
        ((PlayerVelocityEvent)event).setVelocity(vector2);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            case SET: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Vector.class;
                break;
            }
            case DELETE: 
            case RESET: {
                classArray = new Class[]{};
                break;
            }
            default: {
                classArray = null;
            }
        }
        return classArray;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "the new player vector";
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(PlayerVelocityEvent.class)) {
            Skript.error((String)"This expression can only be used in the Player Velocity Change Event!");
            return false;
        }
        return true;
    }

    static {
        Skript.registerExpression(ExprNewVelocity.class, Vector.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the] (new|[new] player) velocity [vector]"});
    }
}

