/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.player.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Pusher")
@Description(value={"Gets the entity which pushed the affected entity in a Damage Push event"})
@Examples(value={"on damage push:\n  broadcast the pusher\n"})
@Since(value={"1.0.2"})
@RequiredPlugins(value={"Paper"})
public class ExprPusher
extends SimpleExpression<Entity> {
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(EntityPushedByEntityAttackEvent.class)) {
            Skript.error((String)"This expression can only be used in the Damage Push Event!");
            return false;
        }
        return true;
    }

    protected Entity @NotNull [] get(@NotNull Event e) {
        return new Entity[]{((EntityPushedByEntityAttackEvent)e).getPushedBy()};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the pusher";
    }

    static {
        if (Skript.classExists((String)"io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent")) {
            Skript.registerExpression(ExprPusher.class, Entity.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the] pusher"});
        }
    }
}

