/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.projectile.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Projectile;

@Name(value="Projectile - has Left The Shooter")
@Description(value={"Gets whether the provided projectiles have left the hitbox of their shooter and can now hit entities.\nThis is recalculated each tick if the projectile has a shooter."})
@Examples(value={"if {_projectile} has left its shooter:"})
@Since(value={"1.3"})
@RequiredPlugins(value={"Paper 1.19.2+"})
public class CondProjectileHasLeftShooter
extends PropertyCondition<Projectile> {
    public boolean check(Projectile value) {
        return value.hasLeftShooter();
    }

    protected String getPropertyName() {
        return "left the shooter";
    }

    static {
        if (Constants.PAPER_1_19_2) {
            CondProjectileHasLeftShooter.register(CondProjectileHasLeftShooter.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.HAVE, (String)"[already] left [the[ir]|its] shooter", (String)"projectiles");
        }
    }
}

