/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.projectile.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.Projectile;

@Name(value="Projectile - has Left The Shooter (Property)")
@Description(value={"Gets whether the provided projectiles have left the hitbox of their shooter and can now hit entities.\nThis is recalculated each tick if the projectile has a shooter.\nCan be set."})
@Examples(value={"set whether {_projectile} has already left its shooter to true"})
@Since(value={"1.3"})
@RequiredPlugins(value={"Paper 1.19.2+"})
public class ExprProjectileHasLeftShooter
extends SimpleBooleanPropertyExpression<Projectile> {
    public Boolean convert(Projectile from) {
        return from.hasLeftShooter();
    }

    protected String getPropertyName() {
        return "left shooter";
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public void set(Projectile from, Boolean to) {
        from.setHasLeftShooter(to.booleanValue());
    }

    static {
        if (Constants.PAPER_1_19_2) {
            ExprProjectileHasLeftShooter.register(ExprProjectileHasLeftShooter.class, Boolean.class, "[projectile]", "[has] [already] left [the[ir]|its] shooter", "projectiles");
        }
    }
}

