/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.skeletonhorse.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Skeleton Horse - Trap Time")
@Description(value={"Returns the trap time of the skeleton horse."})
@Examples(value={"on damage of skeleton horse:\n\tbroadcast skeleton horse trap time of victim"})
@Since(value={"1.0.3"})
public class ExprSkeletonHorseTrapTime
extends SimpleExpression<Timespan> {
    private Expression<LivingEntity> entityExpression;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.entityExpression = exprs[0];
        return true;
    }

    protected Timespan @NotNull [] get(@NotNull Event e) {
        LivingEntity entity = (LivingEntity)this.entityExpression.getSingle(e);
        if (entity instanceof SkeletonHorse) {
            SkeletonHorse skeletonHorse = (SkeletonHorse)entity;
            return new Timespan[]{CompatibilityUtils.fromTicks(skeletonHorse.getTrapTime())};
        }
        return new Timespan[0];
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Timespan.class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object = delta[0];
        if (object instanceof Timespan) {
            Timespan timespan = (Timespan)object;
            object = this.entityExpression.getSingle(e);
            if (object instanceof SkeletonHorse) {
                SkeletonHorse skeletonHorse = (SkeletonHorse)object;
                skeletonHorse.setTrapTime((int)CompatibilityUtils.getTicks(timespan));
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the skeleton horse trap time of " + (e == null ? "" : this.entityExpression.toString(e, debug));
    }

    static {
        Skript.registerExpression(ExprSkeletonHorseTrapTime.class, Timespan.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] skeleton horse trap[ped] time of %livingentity%", "%livingentity%'[s] skeleton horse trap[ped] time"});
    }
}

