/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.skeletonhorse.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Skeleton Horse - Trapped State")
@Description(value={"Returns whether or not a skeleton horse is trapped.\nCan be set."})
@Examples(value={"broadcast skeleton horse trapped state of target"})
@Since(value={"1.0.3"})
public class ExprSkeletonHorseTrappedState
extends SimpleExpression<Boolean> {
    private Expression<Entity> entityExpression;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.entityExpression = exprs[0];
        return true;
    }

    protected Boolean @NotNull [] get(@NotNull Event e) {
        Entity entity = (Entity)this.entityExpression.getSingle(e);
        if (entity instanceof SkeletonHorse) {
            SkeletonHorse skeletonHorse = (SkeletonHorse)entity;
            return new Boolean[]{skeletonHorse.isTrapped()};
        }
        return new Boolean[0];
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Boolean.class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object = delta[0];
        if (object instanceof Boolean) {
            Boolean aBoolean = (Boolean)object;
            object = this.entityExpression.getSingle(e);
            if (object instanceof SkeletonHorse) {
                SkeletonHorse skeletonHorse = (SkeletonHorse)object;
                skeletonHorse.setTrapped(aBoolean.booleanValue());
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the skeleton horse is trapped state of " + (e == null ? "" : this.entityExpression.toString(e, debug));
    }

    static {
        Skript.registerExpression(ExprSkeletonHorseTrappedState.class, Boolean.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] skeleton horse [is] trapped state of %entity%", "%entity%'[s] skeleton horse [is] trapped state", "whether [the] skeleton horse %entity% is trapped [or not]", "whether [or not] [the] skeleton horse %entity% is trapped"});
    }
}

