/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.trident.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.jetbrains.annotations.NotNull;

@Name(value="Trident - has Collided")
@Description(value={"Checks if one or more (thrown) tridents have collided (they must have dealt damage to an entity or have hit the floor)."})
@Examples(value={"if {_trident} has collided:"})
@Since(value={"1.2"})
public class CondTridentCollided
extends PropertyCondition<Projectile> {
    public boolean check(Projectile projectile) {
        Trident trident;
        return projectile instanceof Trident && (trident = (Trident)projectile).hasDealtDamage();
    }

    @NotNull
    protected String getPropertyName() {
        return "collided";
    }

    static {
        CondTridentCollided.register(CondTridentCollided.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.HAVE, (String)"collided", (String)"projectiles");
    }
}

