/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.trident.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.jetbrains.annotations.NotNull;

@Name(value="Trident - is Enchanted")
@Description(value={"Checks if one or more (thrown) tridents are enchanted."})
@Examples(value={"if {_trident} is enchanted:"})
@Since(value={"1.2"})
public class CondTridentEnchanted
extends PropertyCondition<Projectile> {
    public boolean check(Projectile projectile) {
        Trident trident;
        return projectile instanceof Trident && (trident = (Trident)projectile).hasGlint();
    }

    @NotNull
    protected String getPropertyName() {
        return "enchanted";
    }

    static {
        CondTridentEnchanted.register(CondTridentEnchanted.class, (String)"enchanted", (String)"projectiles");
    }
}

