/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.trident.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.jetbrains.annotations.NotNull;

@Name(value="Trident - is Loyal")
@Description(value={"Checks if one or more (thrown) tridents are loyal."})
@Examples(value={"if {_trident} is loyal:"})
@Since(value={"1.2"})
public class CondTridentLoyal
extends PropertyCondition<Projectile> {
    public boolean check(Projectile projectile) {
        Trident trident;
        return projectile instanceof Trident && (trident = (Trident)projectile).getLoyaltyLevel() > 0;
    }

    @NotNull
    protected String getPropertyName() {
        return "loyal";
    }

    static {
        CondTridentLoyal.register(CondTridentLoyal.class, (String)"loyal", (String)"projectiles");
    }
}

