/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.vindicator.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import java.util.ArrayList;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Vindicator;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Vindicator - Johnny State")
@Description(value={"Get and Set whether 1 or more vindicators are Johnny.\nChanging this does not modify the vindicator's name."})
@Examples(value={"if {_vindicator} is johnny:\n\tset whether vindicator {_vindicator} is johnny to false"})
@Since(value={"1.2"})
public class ExprVindicatorJohnny
extends PropertyExpression<LivingEntity, Boolean> {
    protected Boolean @NotNull [] get(@NotNull Event event, LivingEntity @NotNull [] source) {
        ArrayList<Boolean> booleans = new ArrayList<Boolean>();
        for (LivingEntity livingEntity : source) {
            if (!(livingEntity instanceof Vindicator)) continue;
            Vindicator vindicator = (Vindicator)livingEntity;
            booleans.add(vindicator.isJohnny());
        }
        return booleans.toArray(new Boolean[0]);
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @Nullable
    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return new Class[0];
        }
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{Boolean.class};
        }
        return null;
    }

    public void change(@NotNull Event event, @Nullable Object[] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            this.getExpr().stream(event).forEach(livingEntity -> {
                if (livingEntity instanceof Vindicator) {
                    Vindicator vindicator = (Vindicator)livingEntity;
                    vindicator.setJohnny(false);
                }
            });
        } else if (mode == Changer.ChangeMode.SET) {
            if (delta == null) {
                return;
            }
            Object object = delta[0];
            if (object instanceof Boolean) {
                Boolean b = (Boolean)object;
                this.getExpr().stream(event).forEach(livingEntity -> {
                    if (livingEntity instanceof Vindicator) {
                        Vindicator vindicator = (Vindicator)livingEntity;
                        vindicator.setJohnny(b.booleanValue());
                    }
                });
            }
        }
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "the vindicator is johnny state of " + this.getExpr().toString(event, debug);
    }

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.setExpr(expressions[0]);
        return true;
    }

    static {
        Skript.registerExpression(ExprVindicatorJohnny.class, Boolean.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [vindicator] is johnny state of %livingentities%", "%livingentities%'[s] [vindicator] is johnny state", "whether [the] [vindicator[s]] %livingentities% (is|are) johnny [or not]", "whether [or not] [the] [vindicator[s]] %livingentities% (is|are) johnny"});
    }
}

