/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.warden.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Warden;
import org.jetbrains.annotations.NotNull;

@Name(value="Warden - is Agitated")
@Description(value={"Checks if a Warden is agitated."})
@Examples(value={"on damage of warden:\n\tif victim is agitated:\n\t\tbroadcast \"Uh oh\""})
@Since(value={"1.0.2"})
public class CondWardenAgitated
extends PropertyCondition<LivingEntity> {
    public boolean check(LivingEntity entity) {
        Warden warden;
        return Constants.HAS_WARDEN && entity instanceof Warden && (warden = (Warden)entity).getAngerLevel() == Warden.AngerLevel.AGITATED;
    }

    @NotNull
    protected String getPropertyName() {
        return "agitated";
    }

    static {
        CondWardenAgitated.register(CondWardenAgitated.class, (String)"agitated", (String)"livingentities");
    }
}

