/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entities.warden.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Warden;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvtWardenSniff
extends SkriptEvent {
    private Boolean start;

    public boolean init(Literal<?> @NotNull [] args, int matchedPattern, @NotNull SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.start = true;
        } else if (matchedPattern == 1) {
            this.start = false;
        }
        return true;
    }

    public boolean check(@NotNull Event e) {
        EntityPoseChangeEvent event = (EntityPoseChangeEvent)e;
        if (!(event.getEntity() instanceof Warden)) {
            return false;
        }
        if (this.start == null) {
            return true;
        }
        return this.start.booleanValue() ? event.getPose() == Pose.SNIFFING : event.getEntity().getPose() == Pose.SNIFFING;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "warden " + (this.start == null ? "sniff toggle" : (this.start != false ? "sniff start" : "sniff stop"));
    }

    static {
        Skript.registerEvent((String)"Warden - on Sniff Toggle", EvtWardenSniff.class, EntityPoseChangeEvent.class, (String[])new String[]{"warden (sniff[ing] [start|begin]|start sniffing)", "warden (sniff[ing] stop|stop sniffing)", "warden (sniff toggle|toggle sniff)"}).description(new String[]{"Called when a warden sniffs around."}).examples(new String[]{"on warden sniff:\n\tbroadcast event-entity"}).since("1.0.2+");
    }
}

