/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entitysnapshot.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.sections.EffSecSpawn;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.Location;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity Snapshot - Spawn")
@Description(value={"Creates an entity using this template and spawns it at the provided location.\nThis is an effect, not a section and can't be used as such.\nThis effect is heavily influenced by Skript's Spawn effect (EffSecSpawn)."})
@Examples(value={"spawn snapshot {_entitySnapshot} at {_location}"})
@Since(value={"1.3"})
@RequiredPlugins(value={"1.20.2"})
public class EffEntitySnapshotSpawn
extends Effect {
    @Nullable
    private Expression<Number> amount;
    private Expression<EntitySnapshot> snapshots;
    private Expression<Location> locations;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.amount = matchedPattern == 0 ? null : expressions[0];
        this.snapshots = expressions[matchedPattern];
        this.locations = Direction.combine(expressions[1 + matchedPattern], expressions[2 + matchedPattern]);
        return true;
    }

    protected void execute(Event event) {
        Integer numberAmount;
        Number number = numberAmount = this.amount != null ? (Number)((Number)this.amount.getSingle(event)) : (Number)1;
        if (numberAmount != null) {
            double amount = ((Number)numberAmount).doubleValue();
            for (Location location : (Location[])this.locations.getArray(event)) {
                for (EntitySnapshot snapshot : (EntitySnapshot[])this.snapshots.getAll(event)) {
                    int i = 0;
                    while ((double)i < amount) {
                        EffSecSpawn.lastSpawned = snapshot.createEntity(location);
                        ++i;
                    }
                }
            }
        }
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "spawn " + (String)(this.amount != null ? this.amount.toString(event, debug) + " of " : "") + "entity snapshots " + this.snapshots.toString(event, debug) + " " + this.locations.toString(event, debug);
    }

    static {
        if (Constants.HAS_ENTITY_SNAPSHOT) {
            Skript.registerEffect(EffEntitySnapshotSpawn.class, (String[])new String[]{"(spawn|summon) [entity[ |-]]snapshot[s] %entitysnapshots% [%directions% %locations%]", "(spawn|summon) %number% of [entity[ |-]]snapshot[s] %entitysnapshots% [%directions% %locations%]"});
        }
    }
}

