/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.entitysnapshot.expressions;

import ch.njol.skript.bukkitutil.EntityUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;

@Name(value="Entity Snapshot - Entity Type")
@Description(value={"Gets the entity type of the provided entity snapshots."})
@Examples(value={"send entity snapshot type of {_entitySnapshot}"})
@Since(value={"1.3"})
@RequiredPlugins(value={"1.20.2"})
public class ExprEntitySnapshotType
extends SimplePropertyExpression<EntitySnapshot, ch.njol.skript.entity.EntityType> {
    public ch.njol.skript.entity.EntityType convert(EntitySnapshot from) {
        return new ch.njol.skript.entity.EntityType(EntityUtils.toSkriptEntityData((EntityType)from.getEntityType()), 1);
    }

    protected String getPropertyName() {
        return "entity snapshot type";
    }

    public Class<? extends ch.njol.skript.entity.EntityType> getReturnType() {
        return ch.njol.skript.entity.EntityType.class;
    }

    static {
        if (Constants.HAS_ENTITY_SNAPSHOT) {
            ExprEntitySnapshotType.register(ExprEntitySnapshotType.class, ch.njol.skript.entity.EntityType.class, (String)"entity[ |-]snapshot type", (String)"entitysnapshots");
        }
    }
}

