/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.item.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.ItemUtils;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Item - Can Be Enchanted with")
@Description(value={"Checks if an item can be enchanted with an Enchantment.\nThis does not check if the enchantment conflicts with any enchantments already applied on the item."})
@Examples(value={"if tool of player can be enchanted with sharpness:"})
@Since(value={"1.0.0"})
public class CondCanBeEnchanted
extends Condition {
    private Expression<ItemType> item;
    private Expression<Enchantment> enchantment;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        this.item = expressions[0];
        this.enchantment = expressions[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return this.item.toString(event, debug) + " can" + (this.isNegated() ? "'t" : "") + " be enchanted with " + this.enchantment.toString(event, debug);
    }

    public boolean check(@NotNull Event event) {
        Enchantment e = (Enchantment)this.enchantment.getSingle(event);
        if (e == null) {
            return false;
        }
        ItemStack itemStack = ItemUtils.getNullableItemStack((ItemType)this.item.getSingle(event));
        if (itemStack == null) {
            return false;
        }
        return this.isNegated() ^ e.canEnchantItem(itemStack);
    }

    static {
        Skript.registerCondition(CondCanBeEnchanted.class, (String[])new String[]{"%itemtype% can be enchanted with %enchantment%", "%itemtype% can('|no)t be enchanted with %enchantment%"});
    }
}

